// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_
#define ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_

#include "chromeos/strings/grit/chromeos_strings.h"
#include "ui/base/webui/web_ui_util.h"

namespace ash {

const webui::LocalizedString kLocalizedStrings[] = {
    {"appName", IDS_RECORDER_APP_NAME},
    {"backToMainButtonAriaLabel", IDS_RECORDER_BACK_TO_MAIN_BUTTON_ARIA_LABEL},
    {"backToMainButtonTooltip", IDS_RECORDER_BACK_TO_MAIN_BUTTON_TOOLTIP},
    {"closeDialogButtonTooltip", IDS_RECORDER_CLOSE_DIALOG_BUTTON_TOOLTIP},
    {"errorDialogConsentButton", IDS_RECORDER_ERROR_DIALOG_CONSENT_BUTTON},
    {"exportDialogAudioFormatWebmOption",
     IDS_RECORDER_EXPORT_DIALOG_AUDIO_FORMAT_WEBM_OPTION},
    {"exportDialogAudioHeader", IDS_RECORDER_EXPORT_DIALOG_AUDIO_HEADER},
    {"exportDialogCancelButton", IDS_RECORDER_EXPORT_DIALOG_CANCEL_BUTTON},
    {"exportDialogHeader", IDS_RECORDER_EXPORT_DIALOG_HEADER},
    {"exportDialogSaveButton", IDS_RECORDER_EXPORT_DIALOG_SAVE_BUTTON},
    {"exportDialogTranscriptionFormatTxtOption",
     IDS_RECORDER_EXPORT_DIALOG_TRANSCRIPTION_FORMAT_TXT_OPTION},
    {"exportDialogTranscriptionHeader",
     IDS_RECORDER_EXPORT_DIALOG_TRANSCRIPTION_HEADER},
    {"genAiDisclaimerText", IDS_RECORDER_GEN_AI_DISCLAIMER_TEXT},
    {"genAiDownloadErrorStatusMessage",
     IDS_RECORDER_GEN_AI_DOWNLOAD_ERROR_STATUS_MESSAGE},
    {"genAiDownloadFinishedStatusMessage",
     IDS_RECORDER_GEN_AI_DOWNLOAD_FINISHED_STATUS_MESSAGE},
    {"genAiDownloadStartedStatusMessage",
     IDS_RECORDER_GEN_AI_DOWNLOAD_STARTED_STATUS_MESSAGE},
    {"genAiErrorGeneralLabel", IDS_RECORDER_GEN_AI_ERROR_GENERAL_LABEL},
    {"genAiErrorModelDownloadButton",
     IDS_RECORDER_GEN_AI_ERROR_MODEL_DOWNLOAD_BUTTON},
    {"genAiErrorModelDownloadButtonAriaLabel",
     IDS_RECORDER_GEN_AI_ERROR_MODEL_DOWNLOAD_BUTTON_ARIA_LABEL},
    {"genAiErrorModelLoadFailureLabel",
     IDS_RECORDER_GEN_AI_ERROR_MODEL_LOAD_FAILURE_LABEL},
    {"genAiErrorSummaryLanguageUnsupportedLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_LANGUAGE_UNSUPPORTED_LABEL},
    {"genAiErrorSummaryNeedsRebootLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_NEEDS_REBOOT_LABEL},
    {"genAiErrorSummaryTranscriptTooLongLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_TRANSCRIPT_TOO_LONG_LABEL},
    {"genAiErrorSummaryTranscriptTooShortLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_TRANSCRIPT_TOO_SHORT_LABEL},
    {"genAiErrorSummaryTrustAndSafetyLabel",
     IDS_RECORDER_GEN_AI_ERROR_SUMMARY_TRUST_AND_SAFETY_LABEL},
    {"genAiErrorTitleSuggestionLanguageUnsupportedLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_LANGUAGE_UNSUPPORTED_LABEL},
    {"genAiErrorTitleSuggestionNeedsRebootLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_NEEDS_REBOOT_LABEL},
    {"genAiErrorTitleSuggestionTranscriptTooLongLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_TRANSCRIPT_TOO_LONG_LABEL},
    {"genAiErrorTitleSuggestionTranscriptTooShortLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_TRANSCRIPT_TOO_SHORT_LABEL},
    {"genAiErrorTitleSuggestionTrustAndSafetyLabel",
     IDS_RECORDER_GEN_AI_ERROR_TITLE_SUGGESTION_TRUST_AND_SAFETY_LABEL},
    {"genAiExperimentBadge", IDS_RECORDER_GEN_AI_EXPERIMENT_BADGE},
    {"genAiFeedbackModelInputField",
     IDS_RECORDER_GEN_AI_FEEDBACK_MODEL_INPUT_FIELD},
    {"genAiFeedbackPrompt", IDS_RECORDER_GEN_AI_FEEDBACK_PROMPT},
    {"genAiFeedbackSummaryOutputField",
     IDS_RECORDER_GEN_AI_FEEDBACK_SUMMARY_OUTPUT_FIELD},
    {"genAiFeedbackTitleSuggestionOutputField",
     IDS_RECORDER_GEN_AI_FEEDBACK_TITLE_SUGGESTION_OUTPUT_FIELD},
    {"genAiLearnMoreLink", IDS_RECORDER_GEN_AI_LEARN_MORE_LINK},
    {"genAiLearnMoreLinkTooltip", IDS_RECORDER_GEN_AI_LEARN_MORE_LINK_TOOLTIP},
    {"genAiNeedsRebootStatusMessage",
     IDS_RECORDER_GEN_AI_NEEDS_REBOOT_STATUS_MESSAGE},
    {"genaiNegativeFeedbackButtonTooltip",
     IDS_RECORDER_GENAI_NEGATIVE_FEEDBACK_BUTTON_TOOLTIP},
    {"genaiPositiveFeedbackButtonTooltip",
     IDS_RECORDER_GENAI_POSITIVE_FEEDBACK_BUTTON_TOOLTIP},
    {"languageDropdownHintOption", IDS_RECORDER_LANGUAGE_DROPDOWN_HINT_OPTION},
    {"languagePickerAvailableLanguagesHeader",
     IDS_RECORDER_LANGUAGE_PICKER_AVAILABLE_LANGUAGES_HEADER},
    {"languagePickerBackButtonAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_BACK_BUTTON_ARIA_LABEL},
    {"languagePickerBackButtonTooltip",
     IDS_RECORDER_LANGUAGE_PICKER_BACK_BUTTON_TOOLTIP},
    {"languagePickerHeader", IDS_RECORDER_LANGUAGE_PICKER_HEADER},
    {"languagePickerLanguageDownloadButton",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_BUTTON},
    {"languagePickerLanguageDownloadButtonAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_BUTTON_ARIA_LABEL},
    {"languagePickerLanguageDownloadErrorAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_ERROR_ARIA_LABEL},
    {"languagePickerLanguageDownloadErrorStatusMessage",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_ERROR_STATUS_MESSAGE},
    {"languagePickerLanguageDownloadFinishedStatusMessage",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_FINISHED_STATUS_MESSAGE},
    {"languagePickerLanguageDownloadStartedStatusMessage",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOAD_STARTED_STATUS_MESSAGE},
    {"languagePickerLanguageDownloadingAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOADING_ARIA_LABEL},
    {"languagePickerLanguageDownloadingButton",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOADING_BUTTON},
    {"languagePickerLanguageDownloadingProgressDescription",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"languagePickerLanguageErrorDescription",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_ERROR_DESCRIPTION},
    {"languagePickerLanguageNeedsRebootAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_NEEDS_REBOOT_ARIA_LABEL},
    {"languagePickerLanguageNeedsRebootDescription",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_NEEDS_REBOOT_DESCRIPTION},
    {"languagePickerLanguageNeedsRebootStatusMessage",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_NEEDS_REBOOT_STATUS_MESSAGE},
    {"languagePickerLanguageNotDownloadedAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_NOT_DOWNLOADED_ARIA_LABEL},
    {"languagePickerLanguageNotSelectedAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_NOT_SELECTED_ARIA_LABEL},
    {"languagePickerLanguageSelectedAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGE_SELECTED_ARIA_LABEL},
    {"languagePickerLanguagesListLandmarkAriaLabel",
     IDS_RECORDER_LANGUAGE_PICKER_LANGUAGES_LIST_LANDMARK_ARIA_LABEL},
    {"languagePickerSelectedLanguageHeader",
     IDS_RECORDER_LANGUAGE_PICKER_SELECTED_LANGUAGE_HEADER},
    {"languagePickerSelectedLanguageNoneLabel",
     IDS_RECORDER_LANGUAGE_PICKER_SELECTED_LANGUAGE_NONE_LABEL},
    {"mainChooseMicNudge", IDS_RECORDER_MAIN_CHOOSE_MIC_NUDGE},
    {"mainRecordingBarLandmarkAriaLabel",
     IDS_RECORDER_MAIN_RECORDING_BAR_LANDMARK_ARIA_LABEL},
    {"mainRecordingsListLandmarkAriaLabel",
     IDS_RECORDER_MAIN_RECORDINGS_LIST_LANDMARK_ARIA_LABEL},
    {"mainSearchLandmarkAriaLabel",
     IDS_RECORDER_MAIN_SEARCH_LANDMARK_ARIA_LABEL},
    {"mainStartRecordButtonTooltip",
     IDS_RECORDER_MAIN_START_RECORD_BUTTON_TOOLTIP},
    {"mainStartRecordNudge", IDS_RECORDER_MAIN_START_RECORD_NUDGE},
    {"micConnectionErrorDialogDescription",
     IDS_RECORDER_MIC_CONNECTION_ERROR_DIALOG_DESCRIPTION},
    {"micConnectionErrorDialogHeader",
     IDS_RECORDER_MIC_CONNECTION_ERROR_DIALOG_HEADER},
    {"micSelectionMenuButtonTooltip",
     IDS_RECORDER_MIC_SELECTION_MENU_BUTTON_TOOLTIP},
    {"micSelectionMenuMicConnectionErrorDescription",
     IDS_RECORDER_MIC_SELECTION_MENU_MIC_CONNECTION_ERROR_DESCRIPTION},
    {"micSelectionMenuSystemAudioOption",
     IDS_RECORDER_MIC_SELECTION_MENU_SYSTEM_AUDIO_OPTION},
    {"onboardingDialogLanguageSelectionCancelButton",
     IDS_RECORDER_ONBOARDING_DIALOG_LANGUAGE_SELECTION_CANCEL_BUTTON},
    {"onboardingDialogLanguageSelectionDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_LANGUAGE_SELECTION_DESCRIPTION},
    {"onboardingDialogLanguageSelectionDownloadButton",
     IDS_RECORDER_ONBOARDING_DIALOG_LANGUAGE_SELECTION_DOWNLOAD_BUTTON},
    {"onboardingDialogLanguageSelectionHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_LANGUAGE_SELECTION_HEADER},
    {"onboardingDialogSpeakerLabelAllowButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_ALLOW_BUTTON},
    {"onboardingDialogSpeakerLabelDeferButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DEFER_BUTTON},
    {"onboardingDialogSpeakerLabelDescriptionListItem1",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DESCRIPTION_LIST_ITEM_1},
    {"onboardingDialogSpeakerLabelDescriptionListItem2",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DESCRIPTION_LIST_ITEM_2},
    {"onboardingDialogSpeakerLabelDescriptionListItem3",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DESCRIPTION_LIST_ITEM_3},
    {"onboardingDialogSpeakerLabelDescriptionPrefix",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DESCRIPTION_PREFIX},
    {"onboardingDialogSpeakerLabelDescriptionSuffix",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DESCRIPTION_SUFFIX},
    {"onboardingDialogSpeakerLabelDisallowButton",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_DISALLOW_BUTTON},
    {"onboardingDialogSpeakerLabelHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_HEADER},
    {"onboardingDialogSpeakerLabelLearnMoreLink",
     IDS_RECORDER_ONBOARDING_DIALOG_SPEAKER_LABEL_LEARN_MORE_LINK},
    {"onboardingDialogTranscriptionCancelButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_CANCEL_BUTTON},
    {"onboardingDialogTranscriptionDeferButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_DEFER_BUTTON},
    {"onboardingDialogTranscriptionDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_DESCRIPTION},
    {"onboardingDialogTranscriptionDownloadButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_DOWNLOAD_BUTTON},
    {"onboardingDialogTranscriptionHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_HEADER},
    {"onboardingDialogTranscriptionTurnOnButton",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_TURN_ON_BUTTON},
    {"onboardingDialogTranscriptionTurnOnDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_TURN_ON_DESCRIPTION},
    {"onboardingDialogTranscriptionTurnOnHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_TRANSCRIPTION_TURN_ON_HEADER},
    {"onboardingDialogWelcomeDescription",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_DESCRIPTION},
    {"onboardingDialogWelcomeHeader",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_HEADER},
    {"onboardingDialogWelcomeNextButton",
     IDS_RECORDER_ONBOARDING_DIALOG_WELCOME_NEXT_BUTTON},
    {"playbackBackwardButtonTooltip",
     IDS_RECORDER_PLAYBACK_BACKWARD_BUTTON_TOOLTIP},
    {"playbackControlsLandmarkAriaLabel",
     IDS_RECORDER_PLAYBACK_CONTROLS_LANDMARK_ARIA_LABEL},
    {"playbackFloatingVolumeCloseButtonAriaLabel",
     IDS_RECORDER_PLAYBACK_FLOATING_VOLUME_CLOSE_BUTTON_ARIA_LABEL},
    {"playbackFloatingVolumeShowButtonAriaLabel",
     IDS_RECORDER_PLAYBACK_FLOATING_VOLUME_SHOW_BUTTON_ARIA_LABEL},
    {"playbackForwardButtonTooltip",
     IDS_RECORDER_PLAYBACK_FORWARD_BUTTON_TOOLTIP},
    {"playbackHideTranscriptButtonTooltip",
     IDS_RECORDER_PLAYBACK_HIDE_TRANSCRIPT_BUTTON_TOOLTIP},
    {"playbackMenuButtonTooltip", IDS_RECORDER_PLAYBACK_MENU_BUTTON_TOOLTIP},
    {"playbackMenuDeleteOption", IDS_RECORDER_PLAYBACK_MENU_DELETE_OPTION},
    {"playbackMenuExportOption", IDS_RECORDER_PLAYBACK_MENU_EXPORT_OPTION},
    {"playbackMenuShowDetailOption",
     IDS_RECORDER_PLAYBACK_MENU_SHOW_DETAIL_OPTION},
    {"playbackMuteButtonTooltip", IDS_RECORDER_PLAYBACK_MUTE_BUTTON_TOOLTIP},
    {"playbackPauseButtonTooltip", IDS_RECORDER_PLAYBACK_PAUSE_BUTTON_TOOLTIP},
    {"playbackPlayButtonTooltip", IDS_RECORDER_PLAYBACK_PLAY_BUTTON_TOOLTIP},
    {"playbackSeekSliderAriaLabel",
     IDS_RECORDER_PLAYBACK_SEEK_SLIDER_ARIA_LABEL},
    {"playbackShowTranscriptButtonTooltip",
     IDS_RECORDER_PLAYBACK_SHOW_TRANSCRIPT_BUTTON_TOOLTIP},
    {"playbackSpeedButtonTooltip", IDS_RECORDER_PLAYBACK_SPEED_BUTTON_TOOLTIP},
    {"playbackSpeedNormalOption", IDS_RECORDER_PLAYBACK_SPEED_NORMAL_OPTION},
    {"playbackTranscriptLandmarkAriaLabel",
     IDS_RECORDER_PLAYBACK_TRANSCRIPT_LANDMARK_ARIA_LABEL},
    {"playbackUnmuteButtonTooltip",
     IDS_RECORDER_PLAYBACK_UNMUTE_BUTTON_TOOLTIP},
    {"playbackVolumeSliderAriaLabel",
     IDS_RECORDER_PLAYBACK_VOLUME_SLIDER_ARIA_LABEL},
    {"recordDeleteButtonTooltip", IDS_RECORDER_RECORD_DELETE_BUTTON_TOOLTIP},
    {"recordDeleteDialogCancelButton",
     IDS_RECORDER_RECORD_DELETE_DIALOG_CANCEL_BUTTON},
    {"recordDeleteDialogCurrentHeader",
     IDS_RECORDER_RECORD_DELETE_DIALOG_CURRENT_HEADER},
    {"recordDeleteDialogDeleteButton",
     IDS_RECORDER_RECORD_DELETE_DIALOG_DELETE_BUTTON},
    {"recordDeleteDialogDescription",
     IDS_RECORDER_RECORD_DELETE_DIALOG_DESCRIPTION},
    {"recordDeleteDialogHeader", IDS_RECORDER_RECORD_DELETE_DIALOG_HEADER},
    {"recordExitDialogCancelButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_CANCEL_BUTTON},
    {"recordExitDialogDeleteButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_DELETE_BUTTON},
    {"recordExitDialogDescription",
     IDS_RECORDER_RECORD_EXIT_DIALOG_DESCRIPTION},
    {"recordExitDialogHeader", IDS_RECORDER_RECORD_EXIT_DIALOG_HEADER},
    {"recordExitDialogSaveAndExitButton",
     IDS_RECORDER_RECORD_EXIT_DIALOG_SAVE_AND_EXIT_BUTTON},
    {"recordGeneralAudioErrorDialogDescription",
     IDS_RECORDER_RECORD_GENERAL_AUDIO_ERROR_DIALOG_DESCRIPTION},
    {"recordGeneralAudioErrorDialogHeader",
     IDS_RECORDER_RECORD_GENERAL_AUDIO_ERROR_DIALOG_HEADER},
    {"recordHideTranscriptButtonTooltip",
     IDS_RECORDER_RECORD_HIDE_TRANSCRIPT_BUTTON_TOOLTIP},
    {"recordInfoDialogDateLabel", IDS_RECORDER_RECORD_INFO_DIALOG_DATE_LABEL},
    {"recordInfoDialogDurationLabel",
     IDS_RECORDER_RECORD_INFO_DIALOG_DURATION_LABEL},
    {"recordInfoDialogHeader", IDS_RECORDER_RECORD_INFO_DIALOG_HEADER},
    {"recordInfoDialogSizeLabel", IDS_RECORDER_RECORD_INFO_DIALOG_SIZE_LABEL},
    {"recordInfoDialogTitleLabel", IDS_RECORDER_RECORD_INFO_DIALOG_TITLE_LABEL},
    {"recordMenuButtonTooltip", IDS_RECORDER_RECORD_MENU_BUTTON_TOOLTIP},
    {"recordMenuDeleteOption", IDS_RECORDER_RECORD_MENU_DELETE_OPTION},
    {"recordMenuToggleSpeakerLabelOption",
     IDS_RECORDER_RECORD_MENU_TOGGLE_SPEAKER_LABEL_OPTION},
    {"recordMenuToggleTranscriptionOption",
     IDS_RECORDER_RECORD_MENU_TOGGLE_TRANSCRIPTION_OPTION},
    {"recordMuteButtonTooltip", IDS_RECORDER_RECORD_MUTE_BUTTON_TOOLTIP},
    {"recordPauseButtonTooltip", IDS_RECORDER_RECORD_PAUSE_BUTTON_TOOLTIP},
    {"recordResumeButtonTooltip", IDS_RECORDER_RECORD_RESUME_BUTTON_TOOLTIP},
    {"recordShowTranscriptButtonTooltip",
     IDS_RECORDER_RECORD_SHOW_TRANSCRIPT_BUTTON_TOOLTIP},
    {"recordStopButton", IDS_RECORDER_RECORD_STOP_BUTTON},
    {"recordTranscriptionEntryPointDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_DESCRIPTION},
    {"recordTranscriptionEntryPointDisableButton",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_DISABLE_BUTTON},
    {"recordTranscriptionEntryPointEnableButton",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_ENABLE_BUTTON},
    {"recordTranscriptionEntryPointHeader",
     IDS_RECORDER_RECORD_TRANSCRIPTION_ENTRY_POINT_HEADER},
    {"recordTranscriptionOffDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_OFF_DESCRIPTION},
    {"recordTranscriptionOffHeader",
     IDS_RECORDER_RECORD_TRANSCRIPTION_OFF_HEADER},
    {"recordTranscriptionUnusableErrorDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_UNUSABLE_ERROR_DESCRIPTION},
    {"recordTranscriptionUnusableHeader",
     IDS_RECORDER_RECORD_TRANSCRIPTION_UNUSABLE_HEADER},
    {"recordTranscriptionUnusableNeedsRebootDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_UNUSABLE_NEEDS_REBOOT_DESCRIPTION},
    {"recordTranscriptionUnusableNotInstalledDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_UNUSABLE_NOT_INSTALLED_DESCRIPTION},
    {"recordTranscriptionUnusableSelectLanguageDescription",
     IDS_RECORDER_RECORD_TRANSCRIPTION_UNUSABLE_SELECT_LANGUAGE_DESCRIPTION},
    {"recordTranscriptionWaitingDownloadText",
     IDS_RECORDER_RECORD_TRANSCRIPTION_WAITING_DOWNLOAD_TEXT},
    {"recordUnmuteButtonTooltip", IDS_RECORDER_RECORD_UNMUTE_BUTTON_TOOLTIP},
    {"recordingItemOptionsButtonAriaLabel",
     IDS_RECORDER_RECORDING_ITEM_OPTIONS_BUTTON_ARIA_LABEL},
    {"recordingItemOptionsButtonTooltip",
     IDS_RECORDER_RECORDING_ITEM_OPTIONS_BUTTON_TOOLTIP},
    {"recordingItemPauseButtonAriaLabel",
     IDS_RECORDER_RECORDING_ITEM_PAUSE_BUTTON_ARIA_LABEL},
    {"recordingItemPauseButtonTooltip",
     IDS_RECORDER_RECORDING_ITEM_PAUSE_BUTTON_TOOLTIP},
    {"recordingItemPlayButtonAriaLabel",
     IDS_RECORDER_RECORDING_ITEM_PLAY_BUTTON_ARIA_LABEL},
    {"recordingItemPlayButtonTooltip",
     IDS_RECORDER_RECORDING_ITEM_PLAY_BUTTON_TOOLTIP},
    {"recordingListHeader", IDS_RECORDER_RECORDING_LIST_HEADER},
    {"recordingListNoMatchText", IDS_RECORDER_RECORDING_LIST_NO_MATCH_TEXT},
    {"recordingListSearchBoxClearButtonAriaLabel",
     IDS_RECORDER_RECORDING_LIST_SEARCH_BOX_CLEAR_BUTTON_ARIA_LABEL},
    {"recordingListSearchBoxCloseButtonAriaLabel",
     IDS_RECORDER_RECORDING_LIST_SEARCH_BOX_CLOSE_BUTTON_ARIA_LABEL},
    {"recordingListSearchBoxPlaceholder",
     IDS_RECORDER_RECORDING_LIST_SEARCH_BOX_PLACEHOLDER},
    {"recordingListSearchButtonTooltip",
     IDS_RECORDER_RECORDING_LIST_SEARCH_BUTTON_TOOLTIP},
    {"recordingListSortButtonTooltip",
     IDS_RECORDER_RECORDING_LIST_SORT_BUTTON_TOOLTIP},
    {"recordingListSortByDateOption",
     IDS_RECORDER_RECORDING_LIST_SORT_BY_DATE_OPTION},
    {"recordingListSortByTitleOption",
     IDS_RECORDER_RECORDING_LIST_SORT_BY_TITLE_OPTION},
    {"recordingListThisMonthHeader",
     IDS_RECORDER_RECORDING_LIST_THIS_MONTH_HEADER},
    {"recordingListTodayHeader", IDS_RECORDER_RECORDING_LIST_TODAY_HEADER},
    {"recordingListYesterdayHeader",
     IDS_RECORDER_RECORDING_LIST_YESTERDAY_HEADER},
    {"settingsHeader", IDS_RECORDER_SETTINGS_HEADER},
    {"settingsOptionsDoNotDisturbDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_DO_NOT_DISTURB_DESCRIPTION},
    {"settingsOptionsDoNotDisturbLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_DO_NOT_DISTURB_LABEL},
    {"settingsOptionsGenAiDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_DESCRIPTION},
    {"settingsOptionsGenAiDownloadButton",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_DOWNLOAD_BUTTON},
    {"settingsOptionsGenAiDownloadButtonAriaLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_DOWNLOAD_BUTTON_ARIA_LABEL},
    {"settingsOptionsGenAiDownloadingButton",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_DOWNLOADING_BUTTON},
    {"settingsOptionsGenAiDownloadingProgressDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"settingsOptionsGenAiErrorDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_ERROR_DESCRIPTION},
    {"settingsOptionsGenAiLabel", IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_LABEL},
    {"settingsOptionsGenAiLearnMoreLink",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_LEARN_MORE_LINK},
    {"settingsOptionsGenAiLearnMoreLinkAriaLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_LEARN_MORE_LINK_ARIA_LABEL},
    {"settingsOptionsGenAiNeedsRebootDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_GEN_AI_NEEDS_REBOOT_DESCRIPTION},
    {"settingsOptionsKeepScreenOnLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_KEEP_SCREEN_ON_LABEL},
    {"settingsOptionsLanguageSubpageButtonAriaLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_LANGUAGE_SUBPAGE_BUTTON_ARIA_LABEL},
    {"settingsOptionsSpeakerLabelDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_SPEAKER_LABEL_DESCRIPTION},
    {"settingsOptionsSpeakerLabelLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_SPEAKER_LABEL_LABEL},
    {"settingsOptionsTranscriptionDownloadButton",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOAD_BUTTON},
    {"settingsOptionsTranscriptionDownloadButtonAriaLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOAD_BUTTON_ARIA_LABEL},
    {"settingsOptionsTranscriptionDownloadingButton",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOADING_BUTTON},
    {"settingsOptionsTranscriptionDownloadingProgressDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"settingsOptionsTranscriptionErrorDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_ERROR_DESCRIPTION},
    {"settingsOptionsTranscriptionLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_LABEL},
    {"settingsOptionsTranscriptionLanguageDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_LANGUAGE_DESCRIPTION},
    {"settingsOptionsTranscriptionLanguageLabel",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_LANGUAGE_LABEL},
    {"settingsOptionsTranscriptionNeedsRebootDescription",
     IDS_RECORDER_SETTINGS_OPTIONS_TRANSCRIPTION_NEEDS_REBOOT_DESCRIPTION},
    {"settingsSectionGeneralHeader",
     IDS_RECORDER_SETTINGS_SECTION_GENERAL_HEADER},
    {"settingsSectionTranscriptionSummaryHeader",
     IDS_RECORDER_SETTINGS_SECTION_TRANSCRIPTION_SUMMARY_HEADER},
    {"summaryCollapseTooltip", IDS_RECORDER_SUMMARY_COLLAPSE_TOOLTIP},
    {"summaryDisabledLabel", IDS_RECORDER_SUMMARY_DISABLED_LABEL},
    {"summaryDownloadGenAiModelDescription",
     IDS_RECORDER_SUMMARY_DOWNLOAD_GEN_AI_MODEL_DESCRIPTION},
    {"summaryDownloadGenAiModelDisableButton",
     IDS_RECORDER_SUMMARY_DOWNLOAD_GEN_AI_MODEL_DISABLE_BUTTON},
    {"summaryDownloadGenAiModelDownloadButton",
     IDS_RECORDER_SUMMARY_DOWNLOAD_GEN_AI_MODEL_DOWNLOAD_BUTTON},
    {"summaryDownloadGenAiModelHeader",
     IDS_RECORDER_SUMMARY_DOWNLOAD_GEN_AI_MODEL_HEADER},
    {"summaryExpandTooltip", IDS_RECORDER_SUMMARY_EXPAND_TOOLTIP},
    {"summaryFailedStatusMessage", IDS_RECORDER_SUMMARY_FAILED_STATUS_MESSAGE},
    {"summaryFinishedStatusMessage",
     IDS_RECORDER_SUMMARY_FINISHED_STATUS_MESSAGE},
    {"summaryGenAiDownloadingProgressDescription",
     IDS_RECORDER_SUMMARY_GEN_AI_DOWNLOADING_PROGRESS_DESCRIPTION},
    {"summaryHeader", IDS_RECORDER_SUMMARY_HEADER},
    {"summaryStartedStatusMessage",
     IDS_RECORDER_SUMMARY_STARTED_STATUS_MESSAGE},
    {"systemAudioConsentDialogCancelButton",
     IDS_RECORDER_SYSTEM_AUDIO_CONSENT_DIALOG_CANCEL_BUTTON},
    {"systemAudioConsentDialogConsentButton",
     IDS_RECORDER_SYSTEM_AUDIO_CONSENT_DIALOG_CONSENT_BUTTON},
    {"systemAudioConsentDialogDescription",
     IDS_RECORDER_SYSTEM_AUDIO_CONSENT_DIALOG_DESCRIPTION},
    {"systemAudioConsentDialogHeader",
     IDS_RECORDER_SYSTEM_AUDIO_CONSENT_DIALOG_HEADER},
    {"titleEditSnackbarMessage", IDS_RECORDER_TITLE_EDIT_SNACKBAR_MESSAGE},
    {"titleEditTooltip", IDS_RECORDER_TITLE_EDIT_TOOLTIP},
    {"titleSuggestionButtonTooltip",
     IDS_RECORDER_TITLE_SUGGESTION_BUTTON_TOOLTIP},
    {"titleSuggestionFailedStatusMessage",
     IDS_RECORDER_TITLE_SUGGESTION_FAILED_STATUS_MESSAGE},
    {"titleSuggestionFinishedStatusMessage",
     IDS_RECORDER_TITLE_SUGGESTION_FINISHED_STATUS_MESSAGE},
    {"titleSuggestionHeader", IDS_RECORDER_TITLE_SUGGESTION_HEADER},
    {"titleSuggestionStartedStatusMessage",
     IDS_RECORDER_TITLE_SUGGESTION_STARTED_STATUS_MESSAGE},
    {"titleTextfieldAriaLabel", IDS_RECORDER_TITLE_TEXTFIELD_ARIA_LABEL},
    {"transcriptionAutoscrollButton",
     IDS_RECORDER_TRANSCRIPTION_AUTOSCROLL_BUTTON},
    {"transcriptionNoSpeechText", IDS_RECORDER_TRANSCRIPTION_NO_SPEECH_TEXT},
    {"transcriptionSpeakerLabelLabel",
     IDS_RECORDER_TRANSCRIPTION_SPEAKER_LABEL_LABEL},
    {"transcriptionSpeakerLabelPendingLabel",
     IDS_RECORDER_TRANSCRIPTION_SPEAKER_LABEL_PENDING_LABEL},
    {"transcriptionWaitingSpeechText",
     IDS_RECORDER_TRANSCRIPTION_WAITING_SPEECH_TEXT},
};

}  // namespace ash

#endif  // ASH_WEBUI_RECORDER_APP_UI_RESOURCES_H_
